# Motivation_Analysis

This folder contains analysis scripts to investigate the motivation and effects of FAL and FAL+ architectures.

- **Ablation_Analysis/**: Scripts for ablation studies (e.g., removing or modifying model components).
- **Gradient_Analysis/**: Tools for analyzing gradient flow and training dynamics.
- **Similarity_Analysis/**: Scripts for representational similarity analysis (e.g., CKA on Wikitext2).

Use these analyses to better understand the impact of architectural changes on model behavior and performance.

## File Descriptions

| Folder/File                          | Description                                                                                     |
|--------------------------------------|-------------------------------------------------------------------------------------------------|
| `Ablation_Analysis/modify_gpt2_model.py` | Functions to modify GPT-2 model components, such as attention layers.                          |
| `Ablation_Analysis/test_remove.py`   | Script to evaluate the effect of removing specific layers from GPT-2 on validation perplexity. |
| `Ablation_Analysis/test_jump.py`     | Script to analyze the impact of skipping certain layers in GPT-2 during inference.             |
| `Gradient_Analysis/wikitext2.py`     | Tools for capturing gradients and activations during forward passes on Wikitext-2.            |
| `Similarity_Analysis/Wikitext2.py`   | Scripts for representational similarity analysis using CKA on Wikitext-2.                     |

## How to Run

Below are examples of how to run the scripts:

### Ablation Analysis
To evaluate the effect of removing layers:
```bash
python Ablation_Analysis/test_remove.py
```